package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMitigationActionsRequest(
    actionType: Optional[zio.aws.iot.model.MitigationActionType] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest = {
    import ListMitigationActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly =
    zio.aws.iot.model.ListMitigationActionsRequest.wrap(buildAwsValue())
}
object ListMitigationActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListMitigationActionsRequest =
      zio.aws.iot.model.ListMitigationActionsRequest(
        actionType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def actionType: Optional[zio.aws.iot.model.MitigationActionType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getActionType
        : ZIO[Any, AwsError, zio.aws.iot.model.MitigationActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ) extends zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly {
    override val actionType: Optional[zio.aws.iot.model.MitigationActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.iot.model.MitigationActionType.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ): zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly = new Wrapper(impl)
}
