package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListViolationEventsResponse(
    violationEvents: Optional[Iterable[zio.aws.iot.model.ViolationEvent]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListViolationEventsResponse = {
    import ListViolationEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
      .builder()
      .optionallyWith(
        violationEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violationEvents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListViolationEventsResponse.ReadOnly =
    zio.aws.iot.model.ListViolationEventsResponse.wrap(buildAwsValue())
}
object ListViolationEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListViolationEventsResponse =
      zio.aws.iot.model.ListViolationEventsResponse(
        violationEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def violationEvents
        : Optional[List[zio.aws.iot.model.ViolationEvent.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getViolationEvents
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ViolationEvent.ReadOnly]] =
      AwsError.unwrapOptionField("violationEvents", violationEvents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ) extends zio.aws.iot.model.ListViolationEventsResponse.ReadOnly {
    override val violationEvents
        : Optional[List[zio.aws.iot.model.ViolationEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ViolationEvent.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListViolationEventsResponse
  ): zio.aws.iot.model.ListViolationEventsResponse.ReadOnly = new Wrapper(impl)
}
