package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{DateType, OTAUpdateArn, OTAUpdateId}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class OTAUpdateSummary(
    otaUpdateId: Optional[OTAUpdateId] = Optional.Absent,
    otaUpdateArn: Optional[OTAUpdateArn] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.OTAUpdateSummary = {
    import OTAUpdateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.OTAUpdateSummary
      .builder()
      .optionallyWith(
        otaUpdateId.map(value => OTAUpdateId.unwrap(value): java.lang.String)
      )(_.otaUpdateId)
      .optionallyWith(
        otaUpdateArn.map(value => OTAUpdateArn.unwrap(value): java.lang.String)
      )(_.otaUpdateArn)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.OTAUpdateSummary.ReadOnly =
    zio.aws.iot.model.OTAUpdateSummary.wrap(buildAwsValue())
}
object OTAUpdateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.OTAUpdateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.OTAUpdateSummary =
      zio.aws.iot.model.OTAUpdateSummary(
        otaUpdateId.map(value => value),
        otaUpdateArn.map(value => value),
        creationDate.map(value => value)
      )
    def otaUpdateId: Optional[OTAUpdateId]
    def otaUpdateArn: Optional[OTAUpdateArn]
    def creationDate: Optional[DateType]
    def getOtaUpdateId: ZIO[Any, AwsError, OTAUpdateId] =
      AwsError.unwrapOptionField("otaUpdateId", otaUpdateId)
    def getOtaUpdateArn: ZIO[Any, AwsError, OTAUpdateArn] =
      AwsError.unwrapOptionField("otaUpdateArn", otaUpdateArn)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateSummary
  ) extends zio.aws.iot.model.OTAUpdateSummary.ReadOnly {
    override val otaUpdateId: Optional[OTAUpdateId] = zio.aws.core.internal
      .optionalFromNullable(impl.otaUpdateId())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateId(value))
    override val otaUpdateArn: Optional[OTAUpdateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.otaUpdateArn())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateArn(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateSummary
  ): zio.aws.iot.model.OTAUpdateSummary.ReadOnly = new Wrapper(impl)
}
