package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  TemplateArn,
  DateType,
  TemplateName,
  TemplateDescription,
  Enabled
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ProvisioningTemplateSummary(
    templateArn: Optional[TemplateArn] = Optional.Absent,
    templateName: Optional[TemplateName] = Optional.Absent,
    description: Optional[TemplateDescription] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary = {
    import ProvisioningTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly =
    zio.aws.iot.model.ProvisioningTemplateSummary.wrap(buildAwsValue())
}
object ProvisioningTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ProvisioningTemplateSummary =
      zio.aws.iot.model.ProvisioningTemplateSummary(
        templateArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        enabled.map(value => value)
      )
    def templateArn: Optional[TemplateArn]
    def templateName: Optional[TemplateName]
    def description: Optional[TemplateDescription]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def enabled: Optional[Enabled]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ) extends zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly {
    override val templateArn: Optional[TemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val description: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.TemplateDescription(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ): zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly = new Wrapper(impl)
}
