package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleArn, TemplateBody}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegistrationConfig(
    templateBody: Optional[TemplateBody] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegistrationConfig = {
    import RegistrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegistrationConfig
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegistrationConfig.ReadOnly =
    zio.aws.iot.model.RegistrationConfig.wrap(buildAwsValue())
}
object RegistrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegistrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegistrationConfig =
      zio.aws.iot.model.RegistrationConfig(
        templateBody.map(value => value),
        roleArn.map(value => value)
      )
    def templateBody: Optional[TemplateBody]
    def roleArn: Optional[RoleArn]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegistrationConfig
  ) extends zio.aws.iot.model.RegistrationConfig.ReadOnly {
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegistrationConfig
  ): zio.aws.iot.model.RegistrationConfig.ReadOnly = new Wrapper(impl)
}
