package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelatedResource(
    resourceType: Optional[zio.aws.iot.model.ResourceType] = Optional.Absent,
    resourceIdentifier: Optional[zio.aws.iot.model.ResourceIdentifier] =
      Optional.Absent,
    additionalInfo: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RelatedResource = {
    import RelatedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RelatedResource
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        additionalInfo.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalInfo)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RelatedResource.ReadOnly =
    zio.aws.iot.model.RelatedResource.wrap(buildAwsValue())
}
object RelatedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RelatedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RelatedResource =
      zio.aws.iot.model.RelatedResource(
        resourceType.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        additionalInfo.map(value => value)
      )
    def resourceType: Optional[zio.aws.iot.model.ResourceType]
    def resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def additionalInfo: Optional[Map[String, String]]
    def getResourceType: ZIO[Any, AwsError, zio.aws.iot.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getAdditionalInfo: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RelatedResource
  ) extends zio.aws.iot.model.RelatedResource.ReadOnly {
    override val resourceType: Optional[zio.aws.iot.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.iot.model.ResourceType.wrap(value))
    override val resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val additionalInfo: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalInfo())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RelatedResource
  ): zio.aws.iot.model.RelatedResource.ReadOnly = new Wrapper(impl)
}
