package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.iot.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ResourceType
  ): zio.aws.iot.model.ResourceType = value match {
    case software.amazon.awssdk.services.iot.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.DEVICE_CERTIFICATE =>
      val r = DEVICE_CERTIFICATE
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.CA_CERTIFICATE =>
      val r = CA_CERTIFICATE
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.IOT_POLICY =>
      val r = IOT_POLICY
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.COGNITO_IDENTITY_POOL =>
      val r = COGNITO_IDENTITY_POOL
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.CLIENT_ID =>
      val r = CLIENT_ID
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.ACCOUNT_SETTINGS =>
      val r = ACCOUNT_SETTINGS
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.ROLE_ALIAS =>
      val r = ROLE_ALIAS
      r
    case software.amazon.awssdk.services.iot.model.ResourceType.IAM_ROLE =>
      val r = IAM_ROLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEVICE_CERTIFICATE extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.DEVICE_CERTIFICATE
  }
  case object CA_CERTIFICATE extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.CA_CERTIFICATE
  }
  case object IOT_POLICY extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.IOT_POLICY
  }
  case object COGNITO_IDENTITY_POOL extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.COGNITO_IDENTITY_POOL
  }
  case object CLIENT_ID extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.CLIENT_ID
  }
  case object ACCOUNT_SETTINGS extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.ACCOUNT_SETTINGS
  }
  case object ROLE_ALIAS extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.ROLE_ALIAS
  }
  case object IAM_ROLE extends zio.aws.iot.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ResourceType =
      software.amazon.awssdk.services.iot.model.ResourceType.IAM_ROLE
  }
}
