package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuthorizerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetDefaultAuthorizerRequest(authorizerName: AuthorizerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest = {
    import SetDefaultAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SetDefaultAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.SetDefaultAuthorizerRequest.wrap(buildAwsValue())
}
object SetDefaultAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SetDefaultAuthorizerRequest =
      zio.aws.iot.model.SetDefaultAuthorizerRequest(authorizerName)
    def authorizerName: AuthorizerName
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest
  ) extends zio.aws.iot.model.SetDefaultAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest
  ): zio.aws.iot.model.SetDefaultAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
