package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetV2LoggingLevelRequest(
    logTarget: zio.aws.iot.model.LogTarget,
    logLevel: zio.aws.iot.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest = {
    import SetV2LoggingLevelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest
      .builder()
      .logTarget(logTarget.buildAwsValue())
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SetV2LoggingLevelRequest.ReadOnly =
    zio.aws.iot.model.SetV2LoggingLevelRequest.wrap(buildAwsValue())
}
object SetV2LoggingLevelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SetV2LoggingLevelRequest =
      zio.aws.iot.model.SetV2LoggingLevelRequest(logTarget.asEditable, logLevel)
    def logTarget: zio.aws.iot.model.LogTarget.ReadOnly
    def logLevel: zio.aws.iot.model.LogLevel
    def getLogTarget: ZIO[Any, Nothing, zio.aws.iot.model.LogTarget.ReadOnly] =
      ZIO.succeed(logTarget)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iot.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest
  ) extends zio.aws.iot.model.SetV2LoggingLevelRequest.ReadOnly {
    override val logTarget: zio.aws.iot.model.LogTarget.ReadOnly =
      zio.aws.iot.model.LogTarget.wrap(impl.logTarget())
    override val logLevel: zio.aws.iot.model.LogLevel =
      zio.aws.iot.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest
  ): zio.aws.iot.model.SetV2LoggingLevelRequest.ReadOnly = new Wrapper(impl)
}
