package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditTaskId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartOnDemandAuditTaskResponse(
    taskId: Optional[AuditTaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse = {
    import StartOnDemandAuditTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly =
    zio.aws.iot.model.StartOnDemandAuditTaskResponse.wrap(buildAwsValue())
}
object StartOnDemandAuditTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartOnDemandAuditTaskResponse =
      zio.aws.iot.model
        .StartOnDemandAuditTaskResponse(taskId.map(value => value))
    def taskId: Optional[AuditTaskId]
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse
  ) extends zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly {
    override val taskId: Optional[AuditTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse
  ): zio.aws.iot.model.StartOnDemandAuditTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
