package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.EvaluationStatistic
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StatisticalThreshold(
    statistic: Optional[EvaluationStatistic] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StatisticalThreshold = {
    import StatisticalThreshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StatisticalThreshold
      .builder()
      .optionallyWith(
        statistic.map(value =>
          EvaluationStatistic.unwrap(value): java.lang.String
        )
      )(_.statistic)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StatisticalThreshold.ReadOnly =
    zio.aws.iot.model.StatisticalThreshold.wrap(buildAwsValue())
}
object StatisticalThreshold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StatisticalThreshold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StatisticalThreshold =
      zio.aws.iot.model.StatisticalThreshold(statistic.map(value => value))
    def statistic: Optional[EvaluationStatistic]
    def getStatistic: ZIO[Any, AwsError, EvaluationStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StatisticalThreshold
  ) extends zio.aws.iot.model.StatisticalThreshold.ReadOnly {
    override val statistic: Optional[EvaluationStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.iot.model.primitives.EvaluationStatistic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StatisticalThreshold
  ): zio.aws.iot.model.StatisticalThreshold.ReadOnly = new Wrapper(impl)
}
