package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.iot.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.Status
  ): zio.aws.iot.model.Status = value match {
    case software.amazon.awssdk.services.iot.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.Status.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.iot.model.Status.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.iot.model.Status.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.iot.model.Status.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.iot.model.Status.CANCELLING =>
      val r = Cancelling
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.IN_PROGRESS
  }
  case object Completed extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.COMPLETED
  }
  case object Failed extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.FAILED
  }
  case object Cancelled extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.CANCELLED
  }
  case object Cancelling extends zio.aws.iot.model.Status {
    override def unwrap: software.amazon.awssdk.services.iot.model.Status =
      software.amazon.awssdk.services.iot.model.Status.CANCELLING
  }
}
