package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{LastUpdatedAtDate, CreatedAtDate, AwsArn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TopicRuleDestinationSummary(
    arn: Optional[AwsArn] = Optional.Absent,
    status: Optional[zio.aws.iot.model.TopicRuleDestinationStatus] =
      Optional.Absent,
    createdAt: Optional[CreatedAtDate] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAtDate] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    httpUrlSummary: Optional[zio.aws.iot.model.HttpUrlDestinationSummary] =
      Optional.Absent,
    vpcDestinationSummary: Optional[zio.aws.iot.model.VpcDestinationSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary = {
    import TopicRuleDestinationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary
      .builder()
      .optionallyWith(arn.map(value => AwsArn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAt.map(value => CreatedAtDate.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAtDate.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(httpUrlSummary.map(value => value.buildAwsValue()))(
        _.httpUrlSummary
      )
      .optionallyWith(
        vpcDestinationSummary.map(value => value.buildAwsValue())
      )(_.vpcDestinationSummary)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly =
    zio.aws.iot.model.TopicRuleDestinationSummary.wrap(buildAwsValue())
}
object TopicRuleDestinationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRuleDestinationSummary =
      zio.aws.iot.model.TopicRuleDestinationSummary(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        statusReason.map(value => value),
        httpUrlSummary.map(value => value.asEditable),
        vpcDestinationSummary.map(value => value.asEditable)
      )
    def arn: Optional[AwsArn]
    def status: Optional[zio.aws.iot.model.TopicRuleDestinationStatus]
    def createdAt: Optional[CreatedAtDate]
    def lastUpdatedAt: Optional[LastUpdatedAtDate]
    def statusReason: Optional[String]
    def httpUrlSummary
        : Optional[zio.aws.iot.model.HttpUrlDestinationSummary.ReadOnly]
    def vpcDestinationSummary
        : Optional[zio.aws.iot.model.VpcDestinationSummary.ReadOnly]
    def getArn: ZIO[Any, AwsError, AwsArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.TopicRuleDestinationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAtDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAtDate] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getHttpUrlSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.HttpUrlDestinationSummary.ReadOnly
    ] = AwsError.unwrapOptionField("httpUrlSummary", httpUrlSummary)
    def getVpcDestinationSummary
        : ZIO[Any, AwsError, zio.aws.iot.model.VpcDestinationSummary.ReadOnly] =
      AwsError.unwrapOptionField("vpcDestinationSummary", vpcDestinationSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary
  ) extends zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly {
    override val arn: Optional[AwsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iot.model.primitives.AwsArn(value))
    override val status
        : Optional[zio.aws.iot.model.TopicRuleDestinationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.TopicRuleDestinationStatus.wrap(value))
    override val createdAt: Optional[CreatedAtDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.CreatedAtDate(value))
    override val lastUpdatedAt: Optional[LastUpdatedAtDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value => zio.aws.iot.model.primitives.LastUpdatedAtDate(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val httpUrlSummary
        : Optional[zio.aws.iot.model.HttpUrlDestinationSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpUrlSummary())
        .map(value => zio.aws.iot.model.HttpUrlDestinationSummary.wrap(value))
    override val vpcDestinationSummary
        : Optional[zio.aws.iot.model.VpcDestinationSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcDestinationSummary())
        .map(value => zio.aws.iot.model.VpcDestinationSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestinationSummary
  ): zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly = new Wrapper(impl)
}
