package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  CredentialDurationSeconds,
  RoleArn,
  RoleAlias
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRoleAliasRequest(
    roleAlias: RoleAlias,
    roleArn: Optional[RoleArn] = Optional.Absent,
    credentialDurationSeconds: Optional[CredentialDurationSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest = {
    import UpdateRoleAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
      .builder()
      .roleAlias(RoleAlias.unwrap(roleAlias): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        credentialDurationSeconds.map(value =>
          CredentialDurationSeconds.unwrap(value): Integer
        )
      )(_.credentialDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly =
    zio.aws.iot.model.UpdateRoleAliasRequest.wrap(buildAwsValue())
}
object UpdateRoleAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateRoleAliasRequest =
      zio.aws.iot.model.UpdateRoleAliasRequest(
        roleAlias,
        roleArn.map(value => value),
        credentialDurationSeconds.map(value => value)
      )
    def roleAlias: RoleAlias
    def roleArn: Optional[RoleArn]
    def credentialDurationSeconds: Optional[CredentialDurationSeconds]
    def getRoleAlias: ZIO[Any, Nothing, RoleAlias] = ZIO.succeed(roleAlias)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCredentialDurationSeconds
        : ZIO[Any, AwsError, CredentialDurationSeconds] = AwsError
      .unwrapOptionField("credentialDurationSeconds", credentialDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ) extends zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly {
    override val roleAlias: RoleAlias =
      zio.aws.iot.model.primitives.RoleAlias(impl.roleAlias())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val credentialDurationSeconds
        : Optional[CredentialDurationSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialDurationSeconds())
      .map(value =>
        zio.aws.iot.model.primitives.CredentialDurationSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest
  ): zio.aws.iot.model.UpdateRoleAliasRequest.ReadOnly = new Wrapper(impl)
}
