package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  ViolationId,
  Timestamp,
  SecurityProfileName,
  VerificationStateDescription
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ActiveViolation(
    violationId: Optional[ViolationId] = Optional.Absent,
    thingName: Optional[DeviceDefenderThingName] = Optional.Absent,
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    behavior: Optional[zio.aws.iot.model.Behavior] = Optional.Absent,
    lastViolationValue: Optional[zio.aws.iot.model.MetricValue] =
      Optional.Absent,
    violationEventAdditionalInfo: Optional[
      zio.aws.iot.model.ViolationEventAdditionalInfo
    ] = Optional.Absent,
    verificationState: Optional[zio.aws.iot.model.VerificationState] =
      Optional.Absent,
    verificationStateDescription: Optional[VerificationStateDescription] =
      Optional.Absent,
    lastViolationTime: Optional[Timestamp] = Optional.Absent,
    violationStartTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ActiveViolation = {
    import ActiveViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ActiveViolation
      .builder()
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(behavior.map(value => value.buildAwsValue()))(_.behavior)
      .optionallyWith(lastViolationValue.map(value => value.buildAwsValue()))(
        _.lastViolationValue
      )
      .optionallyWith(
        violationEventAdditionalInfo.map(value => value.buildAwsValue())
      )(_.violationEventAdditionalInfo)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        verificationStateDescription.map(value =>
          VerificationStateDescription.unwrap(value): java.lang.String
        )
      )(_.verificationStateDescription)
      .optionallyWith(
        lastViolationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastViolationTime)
      .optionallyWith(
        violationStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.violationStartTime)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ActiveViolation.ReadOnly =
    zio.aws.iot.model.ActiveViolation.wrap(buildAwsValue())
}
object ActiveViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ActiveViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ActiveViolation =
      zio.aws.iot.model.ActiveViolation(
        violationId.map(value => value),
        thingName.map(value => value),
        securityProfileName.map(value => value),
        behavior.map(value => value.asEditable),
        lastViolationValue.map(value => value.asEditable),
        violationEventAdditionalInfo.map(value => value.asEditable),
        verificationState.map(value => value),
        verificationStateDescription.map(value => value),
        lastViolationTime.map(value => value),
        violationStartTime.map(value => value)
      )
    def violationId: Optional[ViolationId]
    def thingName: Optional[DeviceDefenderThingName]
    def securityProfileName: Optional[SecurityProfileName]
    def behavior: Optional[zio.aws.iot.model.Behavior.ReadOnly]
    def lastViolationValue: Optional[zio.aws.iot.model.MetricValue.ReadOnly]
    def violationEventAdditionalInfo
        : Optional[zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly]
    def verificationState: Optional[zio.aws.iot.model.VerificationState]
    def verificationStateDescription: Optional[VerificationStateDescription]
    def lastViolationTime: Optional[Timestamp]
    def violationStartTime: Optional[Timestamp]
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getBehavior: ZIO[Any, AwsError, zio.aws.iot.model.Behavior.ReadOnly] =
      AwsError.unwrapOptionField("behavior", behavior)
    def getLastViolationValue
        : ZIO[Any, AwsError, zio.aws.iot.model.MetricValue.ReadOnly] =
      AwsError.unwrapOptionField("lastViolationValue", lastViolationValue)
    def getViolationEventAdditionalInfo: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "violationEventAdditionalInfo",
      violationEventAdditionalInfo
    )
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.iot.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getVerificationStateDescription
        : ZIO[Any, AwsError, VerificationStateDescription] =
      AwsError.unwrapOptionField(
        "verificationStateDescription",
        verificationStateDescription
      )
    def getLastViolationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastViolationTime", lastViolationTime)
    def getViolationStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("violationStartTime", violationStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ActiveViolation
  ) extends zio.aws.iot.model.ActiveViolation.ReadOnly {
    override val violationId: Optional[ViolationId] = zio.aws.core.internal
      .optionalFromNullable(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val thingName: Optional[DeviceDefenderThingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingName())
        .map(value =>
          zio.aws.iot.model.primitives.DeviceDefenderThingName(value)
        )
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value => zio.aws.iot.model.primitives.SecurityProfileName(value))
    override val behavior: Optional[zio.aws.iot.model.Behavior.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.behavior())
        .map(value => zio.aws.iot.model.Behavior.wrap(value))
    override val lastViolationValue
        : Optional[zio.aws.iot.model.MetricValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastViolationValue())
        .map(value => zio.aws.iot.model.MetricValue.wrap(value))
    override val violationEventAdditionalInfo
        : Optional[zio.aws.iot.model.ViolationEventAdditionalInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationEventAdditionalInfo())
        .map(value =>
          zio.aws.iot.model.ViolationEventAdditionalInfo.wrap(value)
        )
    override val verificationState
        : Optional[zio.aws.iot.model.VerificationState] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationState())
      .map(value => zio.aws.iot.model.VerificationState.wrap(value))
    override val verificationStateDescription
        : Optional[VerificationStateDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationStateDescription())
      .map(value =>
        zio.aws.iot.model.primitives.VerificationStateDescription(value)
      )
    override val lastViolationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastViolationTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val violationStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.violationStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ActiveViolation
  ): zio.aws.iot.model.ActiveViolation.ReadOnly = new Wrapper(impl)
}
