package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ErrorMessage,
  MitigationActionId,
  Timestamp,
  ErrorCode,
  FindingId,
  MitigationActionsTaskId,
  MitigationActionName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AuditMitigationActionExecutionMetadata(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent,
    findingId: Optional[FindingId] = Optional.Absent,
    actionName: Optional[MitigationActionName] = Optional.Absent,
    actionId: Optional[MitigationActionId] = Optional.Absent,
    status: Optional[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata = {
    import AuditMitigationActionExecutionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        findingId.map(value => FindingId.unwrap(value): java.lang.String)
      )(_.findingId)
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        actionId.map(value =>
          MitigationActionId.unwrap(value): java.lang.String
        )
      )(_.actionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly =
    zio.aws.iot.model.AuditMitigationActionExecutionMetadata
      .wrap(buildAwsValue())
}
object AuditMitigationActionExecutionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditMitigationActionExecutionMetadata =
      zio.aws.iot.model.AuditMitigationActionExecutionMetadata(
        taskId.map(value => value),
        findingId.map(value => value),
        actionName.map(value => value),
        actionId.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def taskId: Optional[MitigationActionsTaskId]
    def findingId: Optional[FindingId]
    def actionName: Optional[MitigationActionName]
    def actionId: Optional[MitigationActionId]
    def status
        : Optional[zio.aws.iot.model.AuditMitigationActionsExecutionStatus]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def errorCode: Optional[ErrorCode]
    def message: Optional[ErrorMessage]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionId: ZIO[Any, AwsError, MitigationActionId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ) extends zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
    override val findingId: Optional[FindingId] = zio.aws.core.internal
      .optionalFromNullable(impl.findingId())
      .map(value => zio.aws.iot.model.primitives.FindingId(value))
    override val actionName: Optional[MitigationActionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val actionId: Optional[MitigationActionId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionId(value))
    override val status
        : Optional[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsExecutionStatus.wrap(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.iot.model.primitives.ErrorCode(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata
  ): zio.aws.iot.model.AuditMitigationActionExecutionMetadata.ReadOnly =
    new Wrapper(impl)
}
