package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditTaskId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AuditTaskMetadata(
    taskId: Optional[AuditTaskId] = Optional.Absent,
    taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] = Optional.Absent,
    taskType: Optional[zio.aws.iot.model.AuditTaskType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AuditTaskMetadata = {
    import AuditTaskMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AuditTaskMetadata
      .builder()
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AuditTaskMetadata.ReadOnly =
    zio.aws.iot.model.AuditTaskMetadata.wrap(buildAwsValue())
}
object AuditTaskMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AuditTaskMetadata =
      zio.aws.iot.model.AuditTaskMetadata(
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskType.map(value => value)
      )
    def taskId: Optional[AuditTaskId]
    def taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus]
    def taskType: Optional[zio.aws.iot.model.AuditTaskType]
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskType: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ) extends zio.aws.iot.model.AuditTaskMetadata.ReadOnly {
    override val taskId: Optional[AuditTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.iot.model.AuditTaskStatus.wrap(value))
    override val taskType: Optional[zio.aws.iot.model.AuditTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskType())
        .map(value => zio.aws.iot.model.AuditTaskType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AuditTaskMetadata
  ): zio.aws.iot.model.AuditTaskMetadata.ReadOnly = new Wrapper(impl)
}
