package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsJobTimeoutInProgressTimeoutInMinutes
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsJobTimeoutConfig(
    inProgressTimeoutInMinutes: Optional[
      AwsJobTimeoutInProgressTimeoutInMinutes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig = {
    import AwsJobTimeoutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig
      .builder()
      .optionallyWith(
        inProgressTimeoutInMinutes.map(value =>
          AwsJobTimeoutInProgressTimeoutInMinutes.unwrap(value): java.lang.Long
        )
      )(_.inProgressTimeoutInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly =
    zio.aws.iot.model.AwsJobTimeoutConfig.wrap(buildAwsValue())
}
object AwsJobTimeoutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.AwsJobTimeoutConfig = zio.aws.iot.model
      .AwsJobTimeoutConfig(inProgressTimeoutInMinutes.map(value => value))
    def inProgressTimeoutInMinutes
        : Optional[AwsJobTimeoutInProgressTimeoutInMinutes]
    def getInProgressTimeoutInMinutes
        : ZIO[Any, AwsError, AwsJobTimeoutInProgressTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "inProgressTimeoutInMinutes",
        inProgressTimeoutInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig
  ) extends zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly {
    override val inProgressTimeoutInMinutes
        : Optional[AwsJobTimeoutInProgressTimeoutInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inProgressTimeoutInMinutes())
        .map(value =>
          zio.aws.iot.model.primitives
            .AwsJobTimeoutInProgressTimeoutInMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.AwsJobTimeoutConfig
  ): zio.aws.iot.model.AwsJobTimeoutConfig.ReadOnly = new Wrapper(impl)
}
