package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ForceFlag, Comment, ReasonCode, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelJobRequest(
    jobId: JobId,
    reasonCode: Optional[ReasonCode] = Optional.Absent,
    comment: Optional[Comment] = Optional.Absent,
    force: Optional[ForceFlag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelJobRequest = {
    import CancelJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        force.map(value => ForceFlag.unwrap(value): java.lang.Boolean)
      )(_.force)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelJobRequest.ReadOnly =
    zio.aws.iot.model.CancelJobRequest.wrap(buildAwsValue())
}
object CancelJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelJobRequest =
      zio.aws.iot.model.CancelJobRequest(
        jobId,
        reasonCode.map(value => value),
        comment.map(value => value),
        force.map(value => value)
      )
    def jobId: JobId
    def reasonCode: Optional[ReasonCode]
    def comment: Optional[Comment]
    def force: Optional[ForceFlag]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getForce: ZIO[Any, AwsError, ForceFlag] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelJobRequest
  ) extends zio.aws.iot.model.CancelJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val reasonCode: Optional[ReasonCode] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCode())
      .map(value => zio.aws.iot.model.primitives.ReasonCode(value))
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.iot.model.primitives.Comment(value))
    override val force: Optional[ForceFlag] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => zio.aws.iot.model.primitives.ForceFlag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelJobRequest
  ): zio.aws.iot.model.CancelJobRequest.ReadOnly = new Wrapper(impl)
}
