package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Signature
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeSigningSignature(
    inlineDocument: Optional[Signature] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CodeSigningSignature = {
    import CodeSigningSignature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CodeSigningSignature
      .builder()
      .optionallyWith(
        inlineDocument.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.inlineDocument)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CodeSigningSignature.ReadOnly =
    zio.aws.iot.model.CodeSigningSignature.wrap(buildAwsValue())
}
object CodeSigningSignature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CodeSigningSignature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CodeSigningSignature =
      zio.aws.iot.model.CodeSigningSignature(inlineDocument.map(value => value))
    def inlineDocument: Optional[Signature]
    def getInlineDocument: ZIO[Any, AwsError, Signature] =
      AwsError.unwrapOptionField("inlineDocument", inlineDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningSignature
  ) extends zio.aws.iot.model.CodeSigningSignature.ReadOnly {
    override val inlineDocument: Optional[Signature] = zio.aws.core.internal
      .optionalFromNullable(impl.inlineDocument())
      .map(value =>
        zio.aws.iot.model.primitives
          .Signature(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CodeSigningSignature
  ): zio.aws.iot.model.CodeSigningSignature.ReadOnly = new Wrapper(impl)
}
