package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  JobArn,
  JobDocument,
  JobDocumentSource,
  JobDescription,
  JobTemplateId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateJobTemplateRequest(
    jobTemplateId: JobTemplateId,
    jobArn: Optional[JobArn] = Optional.Absent,
    documentSource: Optional[JobDocumentSource] = Optional.Absent,
    document: Optional[JobDocument] = Optional.Absent,
    description: JobDescription,
    presignedUrlConfig: Optional[zio.aws.iot.model.PresignedUrlConfig] =
      Optional.Absent,
    jobExecutionsRolloutConfig: Optional[
      zio.aws.iot.model.JobExecutionsRolloutConfig
    ] = Optional.Absent,
    abortConfig: Optional[zio.aws.iot.model.AbortConfig] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    jobExecutionsRetryConfig: Optional[
      zio.aws.iot.model.JobExecutionsRetryConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest = {
    import CreateJobTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest
      .builder()
      .jobTemplateId(JobTemplateId.unwrap(jobTemplateId): java.lang.String)
      .optionallyWith(
        jobArn.map(value => JobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        documentSource.map(value =>
          JobDocumentSource.unwrap(value): java.lang.String
        )
      )(_.documentSource)
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .description(JobDescription.unwrap(description): java.lang.String)
      .optionallyWith(presignedUrlConfig.map(value => value.buildAwsValue()))(
        _.presignedUrlConfig
      )
      .optionallyWith(
        jobExecutionsRolloutConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRolloutConfig)
      .optionallyWith(abortConfig.map(value => value.buildAwsValue()))(
        _.abortConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        jobExecutionsRetryConfig.map(value => value.buildAwsValue())
      )(_.jobExecutionsRetryConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateJobTemplateRequest.ReadOnly =
    zio.aws.iot.model.CreateJobTemplateRequest.wrap(buildAwsValue())
}
object CreateJobTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateJobTemplateRequest =
      zio.aws.iot.model.CreateJobTemplateRequest(
        jobTemplateId,
        jobArn.map(value => value),
        documentSource.map(value => value),
        document.map(value => value),
        description,
        presignedUrlConfig.map(value => value.asEditable),
        jobExecutionsRolloutConfig.map(value => value.asEditable),
        abortConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobExecutionsRetryConfig.map(value => value.asEditable)
      )
    def jobTemplateId: JobTemplateId
    def jobArn: Optional[JobArn]
    def documentSource: Optional[JobDocumentSource]
    def document: Optional[JobDocument]
    def description: JobDescription
    def presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly]
    def jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly]
    def abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly]
    def timeoutConfig: Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly]
    def getJobTemplateId: ZIO[Any, Nothing, JobTemplateId] =
      ZIO.succeed(jobTemplateId)
    def getJobArn: ZIO[Any, AwsError, JobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getDocumentSource: ZIO[Any, AwsError, JobDocumentSource] =
      AwsError.unwrapOptionField("documentSource", documentSource)
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
    def getDescription: ZIO[Any, Nothing, JobDescription] =
      ZIO.succeed(description)
    def getPresignedUrlConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      AwsError.unwrapOptionField("presignedUrlConfig", presignedUrlConfig)
    def getJobExecutionsRolloutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRolloutConfig",
      jobExecutionsRolloutConfig
    )
    def getAbortConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AbortConfig.ReadOnly] =
      AwsError.unwrapOptionField("abortConfig", abortConfig)
    def getTimeoutConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getJobExecutionsRetryConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobExecutionsRetryConfig",
      jobExecutionsRetryConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest
  ) extends zio.aws.iot.model.CreateJobTemplateRequest.ReadOnly {
    override val jobTemplateId: JobTemplateId =
      zio.aws.iot.model.primitives.JobTemplateId(impl.jobTemplateId())
    override val jobArn: Optional[JobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.iot.model.primitives.JobArn(value))
    override val documentSource: Optional[JobDocumentSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentSource())
        .map(value => zio.aws.iot.model.primitives.JobDocumentSource(value))
    override val document: Optional[JobDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
    override val description: JobDescription =
      zio.aws.iot.model.primitives.JobDescription(impl.description())
    override val presignedUrlConfig
        : Optional[zio.aws.iot.model.PresignedUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presignedUrlConfig())
        .map(value => zio.aws.iot.model.PresignedUrlConfig.wrap(value))
    override val jobExecutionsRolloutConfig
        : Optional[zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRolloutConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(value))
    override val abortConfig: Optional[zio.aws.iot.model.AbortConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortConfig())
        .map(value => zio.aws.iot.model.AbortConfig.wrap(value))
    override val timeoutConfig
        : Optional[zio.aws.iot.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value => zio.aws.iot.model.TimeoutConfig.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val jobExecutionsRetryConfig
        : Optional[zio.aws.iot.model.JobExecutionsRetryConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExecutionsRetryConfig())
        .map(value => zio.aws.iot.model.JobExecutionsRetryConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest
  ): zio.aws.iot.model.CreateJobTemplateRequest.ReadOnly = new Wrapper(impl)
}
