package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{JobTemplateId, JobTemplateArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateJobTemplateResponse(
    jobTemplateArn: Optional[JobTemplateArn] = Optional.Absent,
    jobTemplateId: Optional[JobTemplateId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse = {
    import CreateJobTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse
      .builder()
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobTemplateId.map(value =>
          JobTemplateId.unwrap(value): java.lang.String
        )
      )(_.jobTemplateId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly =
    zio.aws.iot.model.CreateJobTemplateResponse.wrap(buildAwsValue())
}
object CreateJobTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateJobTemplateResponse =
      zio.aws.iot.model.CreateJobTemplateResponse(
        jobTemplateArn.map(value => value),
        jobTemplateId.map(value => value)
      )
    def jobTemplateArn: Optional[JobTemplateArn]
    def jobTemplateId: Optional[JobTemplateId]
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobTemplateId: ZIO[Any, AwsError, JobTemplateId] =
      AwsError.unwrapOptionField("jobTemplateId", jobTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse
  ) extends zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly {
    override val jobTemplateArn: Optional[JobTemplateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTemplateArn())
        .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobTemplateId: Optional[JobTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTemplateId())
      .map(value => zio.aws.iot.model.primitives.JobTemplateId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse
  ): zio.aws.iot.model.CreateJobTemplateResponse.ReadOnly = new Wrapper(impl)
}
