package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyDocument, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePolicyRequest(
    policyName: PolicyName,
    policyDocument: PolicyDocument,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreatePolicyRequest = {
    import CreatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreatePolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreatePolicyRequest.ReadOnly =
    zio.aws.iot.model.CreatePolicyRequest.wrap(buildAwsValue())
}
object CreatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreatePolicyRequest =
      zio.aws.iot.model.CreatePolicyRequest(
        policyName,
        policyDocument,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyName: PolicyName
    def policyDocument: PolicyDocument
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyRequest
  ) extends zio.aws.iot.model.CreatePolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val policyDocument: PolicyDocument =
      zio.aws.iot.model.primitives.PolicyDocument(impl.policyDocument())
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyRequest
  ): zio.aws.iot.model.CreatePolicyRequest.ReadOnly = new Wrapper(impl)
}
