package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  TemplateVersionId,
  TemplateName,
  TemplateArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateProvisioningTemplateVersionResponse(
    templateArn: Optional[TemplateArn] = Optional.Absent,
    templateName: Optional[TemplateName] = Optional.Absent,
    versionId: Optional[TemplateVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse = {
    import CreateProvisioningTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        versionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly =
    zio.aws.iot.model.CreateProvisioningTemplateVersionResponse
      .wrap(buildAwsValue())
}
object CreateProvisioningTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.CreateProvisioningTemplateVersionResponse =
      zio.aws.iot.model.CreateProvisioningTemplateVersionResponse(
        templateArn.map(value => value),
        templateName.map(value => value),
        versionId.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def templateArn: Optional[TemplateArn]
    def templateName: Optional[TemplateName]
    def versionId: Optional[TemplateVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ) extends zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly {
    override val templateArn: Optional[TemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val versionId: Optional[TemplateVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse
  ): zio.aws.iot.model.CreateProvisioningTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
