package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ScheduledAuditArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateScheduledAuditResponse(
    scheduledAuditArn: Optional[ScheduledAuditArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse = {
    import CreateScheduledAuditResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse
      .builder()
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly =
    zio.aws.iot.model.CreateScheduledAuditResponse.wrap(buildAwsValue())
}
object CreateScheduledAuditResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateScheduledAuditResponse =
      zio.aws.iot.model
        .CreateScheduledAuditResponse(scheduledAuditArn.map(value => value))
    def scheduledAuditArn: Optional[ScheduledAuditArn]
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse
  ) extends zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly {
    override val scheduledAuditArn: Optional[ScheduledAuditArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditArn())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse
  ): zio.aws.iot.model.CreateScheduledAuditResponse.ReadOnly = new Wrapper(impl)
}
