package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTopicRuleDestinationRequest(
    destinationConfiguration: zio.aws.iot.model.TopicRuleDestinationConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest = {
    import CreateTopicRuleDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest
      .builder()
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateTopicRuleDestinationRequest.ReadOnly =
    zio.aws.iot.model.CreateTopicRuleDestinationRequest.wrap(buildAwsValue())
}
object CreateTopicRuleDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateTopicRuleDestinationRequest =
      zio.aws.iot.model
        .CreateTopicRuleDestinationRequest(destinationConfiguration.asEditable)
    def destinationConfiguration
        : zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest
  ) extends zio.aws.iot.model.CreateTopicRuleDestinationRequest.ReadOnly {
    override val destinationConfiguration
        : zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly =
      zio.aws.iot.model.TopicRuleDestinationConfiguration
        .wrap(impl.destinationConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest
  ): zio.aws.iot.model.CreateTopicRuleDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
