package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DimensionName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDimensionRequest(name: DimensionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteDimensionRequest = {
    import DeleteDimensionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteDimensionRequest
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteDimensionRequest.ReadOnly =
    zio.aws.iot.model.DeleteDimensionRequest.wrap(buildAwsValue())
}
object DeleteDimensionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteDimensionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteDimensionRequest =
      zio.aws.iot.model.DeleteDimensionRequest(name)
    def name: DimensionName
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteDimensionRequest
  ) extends zio.aws.iot.model.DeleteDimensionRequest.ReadOnly {
    override val name: DimensionName =
      zio.aws.iot.model.primitives.DimensionName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteDimensionRequest
  ): zio.aws.iot.model.DeleteDimensionRequest.ReadOnly = new Wrapper(impl)
}
