package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMitigationActionRequest(
    actionName: MitigationActionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest = {
    import DeleteMitigationActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest
      .builder()
      .actionName(MitigationActionName.unwrap(actionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteMitigationActionRequest.ReadOnly =
    zio.aws.iot.model.DeleteMitigationActionRequest.wrap(buildAwsValue())
}
object DeleteMitigationActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteMitigationActionRequest =
      zio.aws.iot.model.DeleteMitigationActionRequest(actionName)
    def actionName: MitigationActionName
    def getActionName: ZIO[Any, Nothing, MitigationActionName] =
      ZIO.succeed(actionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest
  ) extends zio.aws.iot.model.DeleteMitigationActionRequest.ReadOnly {
    override val actionName: MitigationActionName =
      zio.aws.iot.model.primitives.MitigationActionName(impl.actionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest
  ): zio.aws.iot.model.DeleteMitigationActionRequest.ReadOnly = new Wrapper(
    impl
  )
}
