package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.StreamId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteStreamRequest(streamId: StreamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteStreamRequest = {
    import DeleteStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteStreamRequest
      .builder()
      .streamId(StreamId.unwrap(streamId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteStreamRequest.ReadOnly =
    zio.aws.iot.model.DeleteStreamRequest.wrap(buildAwsValue())
}
object DeleteStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteStreamRequest =
      zio.aws.iot.model.DeleteStreamRequest(streamId)
    def streamId: StreamId
    def getStreamId: ZIO[Any, Nothing, StreamId] = ZIO.succeed(streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteStreamRequest
  ) extends zio.aws.iot.model.DeleteStreamRequest.ReadOnly {
    override val streamId: StreamId =
      zio.aws.iot.model.primitives.StreamId(impl.streamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteStreamRequest
  ): zio.aws.iot.model.DeleteStreamRequest.ReadOnly = new Wrapper(impl)
}
