package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTopicRuleRequest(ruleName: RuleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest = {
    import DeleteTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.DeleteTopicRuleRequest.wrap(buildAwsValue())
}
object DeleteTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteTopicRuleRequest =
      zio.aws.iot.model.DeleteTopicRuleRequest(ruleName)
    def ruleName: RuleName
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest
  ) extends zio.aws.iot.model.DeleteTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest
  ): zio.aws.iot.model.DeleteTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
