package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.EndpointAddress
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointResponse(
    endpointAddress: Optional[EndpointAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeEndpointResponse = {
    import DescribeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeEndpointResponse
      .builder()
      .optionallyWith(
        endpointAddress.map(value =>
          EndpointAddress.unwrap(value): java.lang.String
        )
      )(_.endpointAddress)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeEndpointResponse.ReadOnly =
    zio.aws.iot.model.DescribeEndpointResponse.wrap(buildAwsValue())
}
object DescribeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeEndpointResponse =
      zio.aws.iot.model
        .DescribeEndpointResponse(endpointAddress.map(value => value))
    def endpointAddress: Optional[EndpointAddress]
    def getEndpointAddress: ZIO[Any, AwsError, EndpointAddress] =
      AwsError.unwrapOptionField("endpointAddress", endpointAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeEndpointResponse
  ) extends zio.aws.iot.model.DescribeEndpointResponse.ReadOnly {
    override val endpointAddress: Optional[EndpointAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointAddress())
        .map(value => zio.aws.iot.model.primitives.EndpointAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeEndpointResponse
  ): zio.aws.iot.model.DescribeEndpointResponse.ReadOnly = new Wrapper(impl)
}
