package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{IndexSchema, IndexName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeIndexResponse(
    indexName: Optional[IndexName] = Optional.Absent,
    indexStatus: Optional[zio.aws.iot.model.IndexStatus] = Optional.Absent,
    schema: Optional[IndexSchema] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeIndexResponse = {
    import DescribeIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeIndexResponse
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        schema.map(value => IndexSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeIndexResponse.ReadOnly =
    zio.aws.iot.model.DescribeIndexResponse.wrap(buildAwsValue())
}
object DescribeIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeIndexResponse =
      zio.aws.iot.model.DescribeIndexResponse(
        indexName.map(value => value),
        indexStatus.map(value => value),
        schema.map(value => value)
      )
    def indexName: Optional[IndexName]
    def indexStatus: Optional[zio.aws.iot.model.IndexStatus]
    def schema: Optional[IndexSchema]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.iot.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getSchema: ZIO[Any, AwsError, IndexSchema] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ) extends zio.aws.iot.model.DescribeIndexResponse.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val indexStatus: Optional[zio.aws.iot.model.IndexStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexStatus())
        .map(value => zio.aws.iot.model.IndexStatus.wrap(value))
    override val schema: Optional[IndexSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.iot.model.primitives.IndexSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexResponse
  ): zio.aws.iot.model.DescribeIndexResponse.ReadOnly = new Wrapper(impl)
}
