package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobTemplateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeJobTemplateRequest(jobTemplateId: JobTemplateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest = {
    import DescribeJobTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest
      .builder()
      .jobTemplateId(JobTemplateId.unwrap(jobTemplateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobTemplateRequest.ReadOnly =
    zio.aws.iot.model.DescribeJobTemplateRequest.wrap(buildAwsValue())
}
object DescribeJobTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobTemplateRequest =
      zio.aws.iot.model.DescribeJobTemplateRequest(jobTemplateId)
    def jobTemplateId: JobTemplateId
    def getJobTemplateId: ZIO[Any, Nothing, JobTemplateId] =
      ZIO.succeed(jobTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest
  ) extends zio.aws.iot.model.DescribeJobTemplateRequest.ReadOnly {
    override val jobTemplateId: JobTemplateId =
      zio.aws.iot.model.primitives.JobTemplateId(impl.jobTemplateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest
  ): zio.aws.iot.model.DescribeJobTemplateRequest.ReadOnly = new Wrapper(impl)
}
