package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ScheduledAuditArn,
  ScheduledAuditName,
  AuditCheckName,
  DayOfMonth
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledAuditResponse(
    frequency: Optional[zio.aws.iot.model.AuditFrequency] = Optional.Absent,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] = Optional.Absent,
    targetCheckNames: Optional[Iterable[AuditCheckName]] = Optional.Absent,
    scheduledAuditName: Optional[ScheduledAuditName] = Optional.Absent,
    scheduledAuditArn: Optional[ScheduledAuditArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse = {
    import DescribeScheduledAuditResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
      .builder()
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .optionallyWith(
        targetCheckNames.map(value =>
          value.map { item =>
            AuditCheckName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetCheckNames)
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly =
    zio.aws.iot.model.DescribeScheduledAuditResponse.wrap(buildAwsValue())
}
object DescribeScheduledAuditResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeScheduledAuditResponse =
      zio.aws.iot.model.DescribeScheduledAuditResponse(
        frequency.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        targetCheckNames.map(value => value),
        scheduledAuditName.map(value => value),
        scheduledAuditArn.map(value => value)
      )
    def frequency: Optional[zio.aws.iot.model.AuditFrequency]
    def dayOfMonth: Optional[DayOfMonth]
    def dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek]
    def targetCheckNames: Optional[List[AuditCheckName]]
    def scheduledAuditName: Optional[ScheduledAuditName]
    def scheduledAuditArn: Optional[ScheduledAuditArn]
    def getFrequency: ZIO[Any, AwsError, zio.aws.iot.model.AuditFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getTargetCheckNames: ZIO[Any, AwsError, List[AuditCheckName]] =
      AwsError.unwrapOptionField("targetCheckNames", targetCheckNames)
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ) extends zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly {
    override val frequency: Optional[zio.aws.iot.model.AuditFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frequency())
        .map(value => zio.aws.iot.model.AuditFrequency.wrap(value))
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dayOfWeek())
        .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
    override val targetCheckNames: Optional[List[AuditCheckName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCheckNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.AuditCheckName(item)
          }.toList
        )
    override val scheduledAuditName: Optional[ScheduledAuditName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditName())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val scheduledAuditArn: Optional[ScheduledAuditArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditArn())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse
  ): zio.aws.iot.model.DescribeScheduledAuditResponse.ReadOnly = new Wrapper(
    impl
  )
}
