package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait DimensionValueOperator {
  def unwrap: software.amazon.awssdk.services.iot.model.DimensionValueOperator
}
object DimensionValueOperator {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DimensionValueOperator
  ): zio.aws.iot.model.DimensionValueOperator = value match {
    case software.amazon.awssdk.services.iot.model.DimensionValueOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DimensionValueOperator.IN =>
      val r = IN
      r
    case software.amazon.awssdk.services.iot.model.DimensionValueOperator.NOT_IN =>
      val r = NOT_IN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.DimensionValueOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DimensionValueOperator =
      software.amazon.awssdk.services.iot.model.DimensionValueOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object IN extends zio.aws.iot.model.DimensionValueOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DimensionValueOperator =
      software.amazon.awssdk.services.iot.model.DimensionValueOperator.IN
  }
  case object NOT_IN extends zio.aws.iot.model.DimensionValueOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DimensionValueOperator =
      software.amazon.awssdk.services.iot.model.DimensionValueOperator.NOT_IN
  }
}
