package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait DomainType {
  def unwrap: software.amazon.awssdk.services.iot.model.DomainType
}
object DomainType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DomainType
  ): zio.aws.iot.model.DomainType = value match {
    case software.amazon.awssdk.services.iot.model.DomainType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DomainType.ENDPOINT =>
      val r = ENDPOINT
      r
    case software.amazon.awssdk.services.iot.model.DomainType.AWS_MANAGED =>
      val r = AWS_MANAGED
      r
    case software.amazon.awssdk.services.iot.model.DomainType.CUSTOMER_MANAGED =>
      val r = CUSTOMER_MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.iot.model.DomainType =
      software.amazon.awssdk.services.iot.model.DomainType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENDPOINT extends zio.aws.iot.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.iot.model.DomainType =
      software.amazon.awssdk.services.iot.model.DomainType.ENDPOINT
  }
  case object AWS_MANAGED extends zio.aws.iot.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.iot.model.DomainType =
      software.amazon.awssdk.services.iot.model.DomainType.AWS_MANAGED
  }
  case object CUSTOMER_MANAGED extends zio.aws.iot.model.DomainType {
    override def unwrap: software.amazon.awssdk.services.iot.model.DomainType =
      software.amazon.awssdk.services.iot.model.DomainType.CUSTOMER_MANAGED
  }
}
