package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaAction(
    destinationArn: AwsArn,
    topic: String,
    key: Optional[String] = Optional.Absent,
    partition: Optional[String] = Optional.Absent,
    clientProperties: Map[String, String]
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.KafkaAction = {
    import KafkaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.KafkaAction
      .builder()
      .destinationArn(AwsArn.unwrap(destinationArn): java.lang.String)
      .topic(topic: java.lang.String)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(partition.map(value => value: java.lang.String))(
        _.partition
      )
      .clientProperties(
        clientProperties
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.KafkaAction.ReadOnly =
    zio.aws.iot.model.KafkaAction.wrap(buildAwsValue())
}
object KafkaAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.KafkaAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.KafkaAction =
      zio.aws.iot.model.KafkaAction(
        destinationArn,
        topic,
        key.map(value => value),
        partition.map(value => value),
        clientProperties
      )
    def destinationArn: AwsArn
    def topic: String
    def key: Optional[String]
    def partition: Optional[String]
    def clientProperties: Map[String, String]
    def getDestinationArn: ZIO[Any, Nothing, AwsArn] =
      ZIO.succeed(destinationArn)
    def getTopic: ZIO[Any, Nothing, String] = ZIO.succeed(topic)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getPartition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("partition", partition)
    def getClientProperties: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(clientProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.KafkaAction
  ) extends zio.aws.iot.model.KafkaAction.ReadOnly {
    override val destinationArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.destinationArn())
    override val topic: String = impl.topic(): String
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val partition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.partition())
      .map(value => value: String)
    override val clientProperties: Map[String, String] = impl
      .clientProperties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.KafkaAction
  ): zio.aws.iot.model.KafkaAction.ReadOnly = new Wrapper(impl)
}
