package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  NextToken,
  MaxResults,
  FindingId,
  MitigationActionsTaskId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAuditMitigationActionsExecutionsRequest(
    taskId: MitigationActionsTaskId,
    actionStatus: Optional[
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = Optional.Absent,
    findingId: FindingId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest = {
    import ListAuditMitigationActionsExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .optionallyWith(actionStatus.map(value => value.unwrap))(_.actionStatus)
      .findingId(FindingId.unwrap(findingId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly =
    zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest
      .wrap(buildAwsValue())
}
object ListAuditMitigationActionsExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest =
      zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest(
        taskId,
        actionStatus.map(value => value),
        findingId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskId: MitigationActionsTaskId
    def actionStatus
        : Optional[zio.aws.iot.model.AuditMitigationActionsExecutionStatus]
    def findingId: FindingId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
    def getActionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = AwsError.unwrapOptionField("actionStatus", actionStatus)
    def getFindingId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(findingId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ) extends zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
    override val actionStatus
        : Optional[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionStatus())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsExecutionStatus.wrap(value)
        )
    override val findingId: FindingId =
      zio.aws.iot.model.primitives.FindingId(impl.findingId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ): zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
