package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{AscendingOrder, Marker, PageSize}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListOutgoingCertificatesRequest(
    pageSize: Optional[PageSize] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    ascendingOrder: Optional[AscendingOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest = {
    import ListOutgoingCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest
      .builder()
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOutgoingCertificatesRequest.ReadOnly =
    zio.aws.iot.model.ListOutgoingCertificatesRequest.wrap(buildAwsValue())
}
object ListOutgoingCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOutgoingCertificatesRequest =
      zio.aws.iot.model.ListOutgoingCertificatesRequest(
        pageSize.map(value => value),
        marker.map(value => value),
        ascendingOrder.map(value => value)
      )
    def pageSize: Optional[PageSize]
    def marker: Optional[Marker]
    def ascendingOrder: Optional[AscendingOrder]
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest
  ) extends zio.aws.iot.model.ListOutgoingCertificatesRequest.ReadOnly {
    override val pageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val ascendingOrder: Optional[AscendingOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ascendingOrder())
        .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest
  ): zio.aws.iot.model.ListOutgoingCertificatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
