package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPoliciesResponse(
    policies: Optional[Iterable[zio.aws.iot.model.Policy]] = Optional.Absent,
    nextMarker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPoliciesResponse = {
    import ListPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPoliciesResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPoliciesResponse.ReadOnly =
    zio.aws.iot.model.ListPoliciesResponse.wrap(buildAwsValue())
}
object ListPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPoliciesResponse =
      zio.aws.iot.model.ListPoliciesResponse(
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]]
    def nextMarker: Optional[Marker]
    def getPolicies
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Policy.ReadOnly]] =
      AwsError.unwrapOptionField("policies", policies)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesResponse
  ) extends zio.aws.iot.model.ListPoliciesResponse.ReadOnly {
    override val policies: Optional[List[zio.aws.iot.model.Policy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Policy.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesResponse
  ): zio.aws.iot.model.ListPoliciesResponse.ReadOnly = new Wrapper(impl)
}
