package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{SkyfallMaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListV2LoggingLevelsRequest(
    targetType: Optional[zio.aws.iot.model.LogTargetType] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[SkyfallMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest = {
    import ListV2LoggingLevelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
      .builder()
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SkyfallMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly =
    zio.aws.iot.model.ListV2LoggingLevelsRequest.wrap(buildAwsValue())
}
object ListV2LoggingLevelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListV2LoggingLevelsRequest =
      zio.aws.iot.model.ListV2LoggingLevelsRequest(
        targetType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def targetType: Optional[zio.aws.iot.model.LogTargetType]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[SkyfallMaxResults]
    def getTargetType: ZIO[Any, AwsError, zio.aws.iot.model.LogTargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SkyfallMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ) extends zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly {
    override val targetType: Optional[zio.aws.iot.model.LogTargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value => zio.aws.iot.model.LogTargetType.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[SkyfallMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.SkyfallMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ): zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly = new Wrapper(impl)
}
