package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MetricDatum(
    timestamp: Optional[Timestamp] = Optional.Absent,
    value: Optional[zio.aws.iot.model.MetricValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.MetricDatum = {
    import MetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MetricDatum
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MetricDatum.ReadOnly =
    zio.aws.iot.model.MetricDatum.wrap(buildAwsValue())
}
object MetricDatum {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.MetricDatum] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MetricDatum =
      zio.aws.iot.model.MetricDatum(
        timestamp.map(value => value),
        value.map(value => value.asEditable)
      )
    def timestamp: Optional[Timestamp]
    def value: Optional[zio.aws.iot.model.MetricValue.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValue: ZIO[Any, AwsError, zio.aws.iot.model.MetricValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MetricDatum
  ) extends zio.aws.iot.model.MetricDatum.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val value: Optional[zio.aws.iot.model.MetricValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.iot.model.MetricValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MetricDatum
  ): zio.aws.iot.model.MetricDatum.ReadOnly = new Wrapper(impl)
}
