package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{VerificationStateDescription, ViolationId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutVerificationStateOnViolationRequest(
    violationId: ViolationId,
    verificationState: zio.aws.iot.model.VerificationState,
    verificationStateDescription: Optional[VerificationStateDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest = {
    import PutVerificationStateOnViolationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest
      .builder()
      .violationId(ViolationId.unwrap(violationId): java.lang.String)
      .verificationState(verificationState.unwrap)
      .optionallyWith(
        verificationStateDescription.map(value =>
          VerificationStateDescription.unwrap(value): java.lang.String
        )
      )(_.verificationStateDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.PutVerificationStateOnViolationRequest.ReadOnly =
    zio.aws.iot.model.PutVerificationStateOnViolationRequest
      .wrap(buildAwsValue())
}
object PutVerificationStateOnViolationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PutVerificationStateOnViolationRequest =
      zio.aws.iot.model.PutVerificationStateOnViolationRequest(
        violationId,
        verificationState,
        verificationStateDescription.map(value => value)
      )
    def violationId: ViolationId
    def verificationState: zio.aws.iot.model.VerificationState
    def verificationStateDescription: Optional[VerificationStateDescription]
    def getViolationId: ZIO[Any, Nothing, ViolationId] =
      ZIO.succeed(violationId)
    def getVerificationState
        : ZIO[Any, Nothing, zio.aws.iot.model.VerificationState] =
      ZIO.succeed(verificationState)
    def getVerificationStateDescription
        : ZIO[Any, AwsError, VerificationStateDescription] =
      AwsError.unwrapOptionField(
        "verificationStateDescription",
        verificationStateDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest
  ) extends zio.aws.iot.model.PutVerificationStateOnViolationRequest.ReadOnly {
    override val violationId: ViolationId =
      zio.aws.iot.model.primitives.ViolationId(impl.violationId())
    override val verificationState: zio.aws.iot.model.VerificationState =
      zio.aws.iot.model.VerificationState.wrap(impl.verificationState())
    override val verificationStateDescription
        : Optional[VerificationStateDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationStateDescription())
      .map(value =>
        zio.aws.iot.model.primitives.VerificationStateDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest
  ): zio.aws.iot.model.PutVerificationStateOnViolationRequest.ReadOnly =
    new Wrapper(impl)
}
