package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AwsArn, ServiceName, SigningRegion}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SigV4Authorization(
    signingRegion: SigningRegion,
    serviceName: ServiceName,
    roleArn: AwsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SigV4Authorization = {
    import SigV4Authorization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SigV4Authorization
      .builder()
      .signingRegion(SigningRegion.unwrap(signingRegion): java.lang.String)
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SigV4Authorization.ReadOnly =
    zio.aws.iot.model.SigV4Authorization.wrap(buildAwsValue())
}
object SigV4Authorization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SigV4Authorization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SigV4Authorization =
      zio.aws.iot.model.SigV4Authorization(signingRegion, serviceName, roleArn)
    def signingRegion: SigningRegion
    def serviceName: ServiceName
    def roleArn: AwsArn
    def getSigningRegion: ZIO[Any, Nothing, SigningRegion] =
      ZIO.succeed(signingRegion)
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SigV4Authorization
  ) extends zio.aws.iot.model.SigV4Authorization.ReadOnly {
    override val signingRegion: SigningRegion =
      zio.aws.iot.model.primitives.SigningRegion(impl.signingRegion())
    override val serviceName: ServiceName =
      zio.aws.iot.model.primitives.ServiceName(impl.serviceName())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SigV4Authorization
  ): zio.aws.iot.model.SigV4Authorization.ReadOnly = new Wrapper(impl)
}
