package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{UseBase64, QueueUrl, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqsAction(
    roleArn: AwsArn,
    queueUrl: QueueUrl,
    useBase64: Optional[UseBase64] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.SqsAction = {
    import SqsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SqsAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .queueUrl(QueueUrl.unwrap(queueUrl): java.lang.String)
      .optionallyWith(
        useBase64.map(value => UseBase64.unwrap(value): java.lang.Boolean)
      )(_.useBase64)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SqsAction.ReadOnly =
    zio.aws.iot.model.SqsAction.wrap(buildAwsValue())
}
object SqsAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.SqsAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SqsAction = zio.aws.iot.model
      .SqsAction(roleArn, queueUrl, useBase64.map(value => value))
    def roleArn: AwsArn
    def queueUrl: QueueUrl
    def useBase64: Optional[UseBase64]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getQueueUrl: ZIO[Any, Nothing, QueueUrl] = ZIO.succeed(queueUrl)
    def getUseBase64: ZIO[Any, AwsError, UseBase64] =
      AwsError.unwrapOptionField("useBase64", useBase64)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SqsAction
  ) extends zio.aws.iot.model.SqsAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val queueUrl: QueueUrl =
      zio.aws.iot.model.primitives.QueueUrl(impl.queueUrl())
    override val useBase64: Optional[UseBase64] = zio.aws.core.internal
      .optionalFromNullable(impl.useBase64())
      .map(value => zio.aws.iot.model.primitives.UseBase64(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SqsAction
  ): zio.aws.iot.model.SqsAction.ReadOnly = new Wrapper(impl)
}
