package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditCheckName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartOnDemandAuditTaskRequest(
    targetCheckNames: Iterable[AuditCheckName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest = {
    import StartOnDemandAuditTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest
      .builder()
      .targetCheckNames(targetCheckNames.map { item =>
        AuditCheckName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StartOnDemandAuditTaskRequest.ReadOnly =
    zio.aws.iot.model.StartOnDemandAuditTaskRequest.wrap(buildAwsValue())
}
object StartOnDemandAuditTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartOnDemandAuditTaskRequest =
      zio.aws.iot.model.StartOnDemandAuditTaskRequest(targetCheckNames)
    def targetCheckNames: List[AuditCheckName]
    def getTargetCheckNames: ZIO[Any, Nothing, List[AuditCheckName]] =
      ZIO.succeed(targetCheckNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest
  ) extends zio.aws.iot.model.StartOnDemandAuditTaskRequest.ReadOnly {
    override val targetCheckNames: List[AuditCheckName] = impl
      .targetCheckNames()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.AuditCheckName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest
  ): zio.aws.iot.model.StartOnDemandAuditTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
