package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SigningProfileName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartSigningJobParameter(
    signingProfileParameter: Optional[
      zio.aws.iot.model.SigningProfileParameter
    ] = Optional.Absent,
    signingProfileName: Optional[SigningProfileName] = Optional.Absent,
    destination: Optional[zio.aws.iot.model.Destination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartSigningJobParameter = {
    import StartSigningJobParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartSigningJobParameter
      .builder()
      .optionallyWith(
        signingProfileParameter.map(value => value.buildAwsValue())
      )(_.signingProfileParameter)
      .optionallyWith(
        signingProfileName.map(value =>
          SigningProfileName.unwrap(value): java.lang.String
        )
      )(_.signingProfileName)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StartSigningJobParameter.ReadOnly =
    zio.aws.iot.model.StartSigningJobParameter.wrap(buildAwsValue())
}
object StartSigningJobParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartSigningJobParameter =
      zio.aws.iot.model.StartSigningJobParameter(
        signingProfileParameter.map(value => value.asEditable),
        signingProfileName.map(value => value),
        destination.map(value => value.asEditable)
      )
    def signingProfileParameter
        : Optional[zio.aws.iot.model.SigningProfileParameter.ReadOnly]
    def signingProfileName: Optional[SigningProfileName]
    def destination: Optional[zio.aws.iot.model.Destination.ReadOnly]
    def getSigningProfileParameter: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.SigningProfileParameter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "signingProfileParameter",
      signingProfileParameter
    )
    def getSigningProfileName: ZIO[Any, AwsError, SigningProfileName] =
      AwsError.unwrapOptionField("signingProfileName", signingProfileName)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.iot.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ) extends zio.aws.iot.model.StartSigningJobParameter.ReadOnly {
    override val signingProfileParameter
        : Optional[zio.aws.iot.model.SigningProfileParameter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingProfileParameter())
        .map(value => zio.aws.iot.model.SigningProfileParameter.wrap(value))
    override val signingProfileName: Optional[SigningProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingProfileName())
        .map(value => zio.aws.iot.model.primitives.SigningProfileName(value))
    override val destination: Optional[zio.aws.iot.model.Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.iot.model.Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartSigningJobParameter
  ): zio.aws.iot.model.StartSigningJobParameter.ReadOnly = new Wrapper(impl)
}
