package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait TargetSelection {
  def unwrap: software.amazon.awssdk.services.iot.model.TargetSelection
}
object TargetSelection {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.TargetSelection
  ): zio.aws.iot.model.TargetSelection = value match {
    case software.amazon.awssdk.services.iot.model.TargetSelection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.TargetSelection.CONTINUOUS =>
      val r = CONTINUOUS
      r
    case software.amazon.awssdk.services.iot.model.TargetSelection.SNAPSHOT =>
      val r = SNAPSHOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.TargetSelection {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TargetSelection =
      software.amazon.awssdk.services.iot.model.TargetSelection.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUOUS extends zio.aws.iot.model.TargetSelection {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TargetSelection =
      software.amazon.awssdk.services.iot.model.TargetSelection.CONTINUOUS
  }
  case object SNAPSHOT extends zio.aws.iot.model.TargetSelection {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TargetSelection =
      software.amazon.awssdk.services.iot.model.TargetSelection.SNAPSHOT
  }
}
