package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait TemplateType {
  def unwrap: software.amazon.awssdk.services.iot.model.TemplateType
}
object TemplateType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.TemplateType
  ): zio.aws.iot.model.TemplateType = value match {
    case software.amazon.awssdk.services.iot.model.TemplateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.TemplateType.FLEET_PROVISIONING =>
      val r = FLEET_PROVISIONING
      r
    case software.amazon.awssdk.services.iot.model.TemplateType.JITP =>
      val r = JITP
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TemplateType =
      software.amazon.awssdk.services.iot.model.TemplateType.UNKNOWN_TO_SDK_VERSION
  }
  case object FLEET_PROVISIONING extends zio.aws.iot.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TemplateType =
      software.amazon.awssdk.services.iot.model.TemplateType.FLEET_PROVISIONING
  }
  case object JITP extends zio.aws.iot.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.TemplateType =
      software.amazon.awssdk.services.iot.model.TemplateType.JITP
  }
}
