package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestAuthorizationResponse(
    authResults: Optional[Iterable[zio.aws.iot.model.AuthResult]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestAuthorizationResponse = {
    import TestAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestAuthorizationResponse
      .builder()
      .optionallyWith(
        authResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestAuthorizationResponse.ReadOnly =
    zio.aws.iot.model.TestAuthorizationResponse.wrap(buildAwsValue())
}
object TestAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestAuthorizationResponse =
      zio.aws.iot.model.TestAuthorizationResponse(
        authResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def authResults: Optional[List[zio.aws.iot.model.AuthResult.ReadOnly]]
    def getAuthResults
        : ZIO[Any, AwsError, List[zio.aws.iot.model.AuthResult.ReadOnly]] =
      AwsError.unwrapOptionField("authResults", authResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationResponse
  ) extends zio.aws.iot.model.TestAuthorizationResponse.ReadOnly {
    override val authResults
        : Optional[List[zio.aws.iot.model.AuthResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.AuthResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationResponse
  ): zio.aws.iot.model.TestAuthorizationResponse.ReadOnly = new Wrapper(impl)
}
